﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

[System.Serializable]
public class SppLoginData {
	public string server = "http://www.sparepartsplace.com";
	public string catalog = "Demo";
	public string user = "Demo";
	public string password = "demo";

	public void Save() {
		PlayerPrefs.SetString ("spp.loginData.server", server);
		PlayerPrefs.SetString ("spp.loginData.catalog", catalog);
		PlayerPrefs.SetString ("spp.loginData.user", user);
		PlayerPrefs.SetString ("spp.loginData.password", password);
		PlayerPrefs.Save ();
	}

	public void Load() {
		server = PlayerPrefs.GetString ("spp.loginData.server", "http://www.sparepartsplace.com");	
		catalog = PlayerPrefs.GetString ("spp.loginData.catalog", "Demo");	
		user = PlayerPrefs.GetString ("spp.loginData.user", "Demo");	
		password = PlayerPrefs.GetString ("spp.loginData.password", "Demo");	
	}

	public void Reset() {
		server = "http://www.sparepartsplace.com";
		catalog = "Demo";
		user = "Demo";
		password = "demo";
	}	
}

public class SppConfig  {
	public enum RenderMode {MatCap, Legacy, PBR};
	public static RenderMode renderMode = RenderMode.PBR;	
	public static SppLoginData loginData = new SppLoginData();
	public static Quaternion basicRotation = Quaternion.identity;
	public const float SPP_SCALE = 0.01f;
}
